<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Beritas;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Card;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\ImageColumn;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use App\Filament\Resources\BeritaResource\Pages;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\BeritaResource\RelationManagers;
use Filament\Forms\Components\RichEditor;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Forms\Components\Select;
use App\Models\Kategori;

class BeritaResource extends Resource
{
    protected static ?string $model = Beritas::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Card::make()
                    ->schema([
                        TextInput::make('judul')->required(),
                        RichEditor::make('deskripsi')
                            ->fileAttachmentsDisk('public') // gunakan 'public' agar bisa diakses dari web
                            ->fileAttachmentsDirectory('uploads/berita') // folder penyimpanan gambar
                            ->fileAttachmentsVisibility('public') // agar gambar bisa diakses publik
                            ->required()
                            ->columnSpanFull(),
                        FileUpload::make('gambar')
                            ->image()
                            ->multiple() // Tambahkan ini
                            ->acceptedFileTypes(['image/jpg', 'image/jpeg']) // perbaikan di sini
                            ->maxSize(2048) // Maksimal ukuran file 2MB
                            ->disk('public')
                            ->directory('beritas') // Simpan di storage/app/public/berita
                            ->required(),
                        Select::make('kategori_id')
                            ->label('Kategori')
                            ->options(fn () => Kategori::pluck('nama', 'id'))
                            ->searchable()
                            ->required(),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('judul'),
                ImageColumn::make('gambar')
                    ->disk('public')
                    ->circular(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBeritas::route('/'),
            'create' => Pages\CreateBerita::route('/create'),
            'edit' => Pages\EditBerita::route('/{record}/edit'),
        ];
    }
}
