<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Beritas;
use App\Models\Kategori;

class BeritaController extends Controller
{
    public function list(Request $request)
    {
        $query = Beritas::query();

        // Filter kategori
        if ($request->filled('kategori')) {
            $query->where('kategori_id', $request->kategori);
        }

        // Filter by date
        if ($request->filled('tanggal')) {
            $query->whereDate('created_at', $request->tanggal);
        }

        // Search by judul
        if ($request->filled('search')) {
            $query->where('judul', 'like', '%' . $request->search . '%');
        }

        $beritas = $query->orderBy('created_at', 'desc')->paginate(6);
        $kategoriList = Kategori::withCount('beritas')->get();

        return view('mainweb.berita', compact('beritas', 'kategoriList'));
    }

    public function detail($slug)
    {
        $berita = Beritas::where('slug', $slug)->firstOrFail();
        $beritaTerbaru = Beritas::where('id', '!=', $berita->id)
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        return view('mainweb.berita.detailberita', compact('berita', 'beritaTerbaru'));
    }
}