<?php

namespace App\Models;

use table;
use App\Models\Beritas;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;

class Beritas extends Model
{
    use HasFactory;
    protected $table = 'beritas';
    protected $fillable = [
        'judul',
        'slug',
        'deskripsi',
        'gambar',
        'kategori_id', // Pastikan ini ada!
    ];
    protected $casts = [
        'gambar' => 'array', // Tambahkan ini agar otomatis array
    ];

    protected static function booted()
    {
        static::saving(function ($berita) {
            $berita->slug = \Illuminate\Support\Str::slug($berita->judul);
        });
    }

    public function kategori()
    {
        return $this->belongsTo(\App\Models\Kategori::class, 'kategori_id');
    }
}
