<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kategori extends Model
{
    use HasFactory;

    protected $table = 'kategori';
    protected $fillable = ['slug', 'nama'];

    public function beritas()
    {
        return $this->hasMany(\App\Models\Beritas::class, 'kategori_id');
    }

    // Slug otomatis
    protected static function booted()
    {
        static::saving(function ($kategori) {
            $kategori->slug = \Illuminate\Support\Str::slug($kategori->nama);
        });
    }
}
